package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.Data;

import java.io.Serializable;

@Data
public class FarmVideoDeviceInfoDto implements Serializable {

    private static final long serialVersionUID = -1186167508222662755L;

    private String appKey;

    private String deviceId;

    private String userId;

    /**
     * iOS 必填
     */
    private String idfa;

    /**
     * Android 必填
     */
    private String imei;

    /**
     * Android Q 必填
     */
    private String oaid;

    /**
     * Mac 地址 非必填
     */
    private String mac;

    /**
     * 操作系统 非必填
     */
    private String osType;

    /**
     * 系统版本号 非必填
     */
    private String osVersion;

    /**
     * 设备类型：1- 手机、2- 平板 非必填
     */
    private Integer deviceType;

    /**
     * 设备厂商 非必填
     */
    private String vendor;

    /**
     * 手机品牌 非必填
     */
    private String brand;

    /**
     * 设备型号 非必填
     */
    private String model;

    /**
     * 设备屏幕宽度 非必填
     */
    private Integer screenWidth;

    /**
     * 设备屏幕高度 非必填
     */
    private Integer screenHeight;

    /**
     * 像素密度 非必填
     */
    private Integer ppi;

    /**
     * imsi 非必填
     */
    private String imsi;

    /**
     * 运营商类型: 0- 未知、1- 中国移动、2- 中国电信、3- 中国联通、99-其他运营商 非必填
     */
    private Integer operatorType;

    /**
     * 网络类型: 0- 未知网络、2- 2G、3- 3G、4- 4G、5- 5G、100-WIFI、101-ETHERNET、999-NEW_TYPE 非必填
     */
    private Integer connectionType;

    /**
     * 纬度 非必填
     */
    private Double lat;

    /**
     * 经度 非必填
     */
    private Double lon;

    /**
     * 基站ID 非必填
     */
    private String cellularId;


}
