package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Objects;

/**
 * FarmFruitConfigKeyDto
 *
 * @author huangruodan
 * @date 2020-01-04
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class FarmFruitConfigKeyDto implements Serializable {

    private static final long serialVersionUID = 7455835194260979611L;

    private Integer type;

    private Integer level;

    private Integer configVersion;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FarmFruitConfigKeyDto that = (FarmFruitConfigKeyDto) o;
        return type.equals(that.type) &&
                level.equals(that.level) &&
                configVersion.equals(that.configVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, level, configVersion);
    }
}
