package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmMissionDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmFinishMissopnReq;

import java.util.List;

/**
 * [红包农场]任务
 * Created by xuefeng on 2019/12/5.
 */
@AdvancedFeignClient
public interface RemoteFarmMissionService {

    /**
     * 完成指定任务
     *
     * @param req
     * @return
     */
    FarmDto finishMission(FarmFinishMissopnReq req) throws BizException;


    /**
     * 任务列表
     * @param userReq 用户信息
     * @return 任务
     * @throws BizException 业务异常
     */
    List<FarmMissionDto> getMissionList(FarmUserReq userReq) throws BizException;
}
