package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.finance;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.FinanceConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.config.ReqAppDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.config.ReqFinanceConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.config.ReqFinanceConfigRecordDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.config.RspAppDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.config.RspFinanceConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.config.RspFinanceConfigRecordDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.req.FinanceConfigReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteFinanceConfigService {

    /**
     * 获取深度互动的媒体列表
     */
    PageResultDto<RspAppDto> getAppList(ReqAppDto req);

    /**
     * 校验媒体是否已经配置
     */
    Boolean isAppExist(ReqAppDto req);

    /**
     * 查询单个媒体的财务模型配置
     */
    RspFinanceConfigDto queryFinanceConfigByAppId(Long appId) throws BizException;

    /**
     * 添加财务模型配置
     */
    void addOrUpdateFinanceConfig(ReqFinanceConfigDto req) throws BizException;

    /**
     * 查询媒体的财务配置修改记录
     */
    PageResultDto<RspFinanceConfigRecordDto> getFinanceConfigRecordList(ReqFinanceConfigRecordDto req);



    int delete(Long id);

    int deleteByAppIdAndStage(FinanceConfigReq req);

    int insert(FinanceConfigDto financeConfig);

    int update(FinanceConfigDto financeConfig);

    int addBudget(FinanceConfigDto financeConfig);

    FinanceConfigDto getById(Long id);

    FinanceConfigDto selectByAppIdAndStage(FinanceConfigReq req);

    List<FinanceConfigDto> queryByParams(FinanceConfigDto req);

    Integer getCountByParams(FinanceConfigDto req);

}
