package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.plant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.PrettyCashStageDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission.req.FinishMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission.req.JoinNativeReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.LotteryDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PlantDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PropDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.PlantPropReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.ResetForTestReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.UpdateSeedReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.FinishMoonRewardReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.PlantV5UserReq;

/**
 * RemotePlantV5Service
 *
 * @author huangruodan
 * @date 2019-07-21
 */

@AdvancedFeignClient
public interface RemotePlantV5Service {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(PlantV5UserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param req      用户参数
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(PlantV5UserReq req) throws BizException;

    /**
     * 采摘红包
     *
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(PlantV5UserReq req) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param req 用户参数、missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(FinishMissionReq req) throws BizException;



    /**
     * 用户使用道具，
     *
     * @param req landId,propTye,user
     * @return
     * @throws BizException
     */
    PropDto useProp(PlantPropReq req) throws BizException;

    /**
     * @param req
     * @return
     * @throws BizException
     */
    LotteryDto lotteryEveryday(PlantV5UserReq req) throws BizException;


    /**
     * @param req
     * @return
     * @throws BizException
     */
    int finishVat(CommercialUserReq req) throws BizException;

    /**
     * 换天接口
     * @param req deviceId、appId、date
     * @return
     * @throws BizException
     */
    Boolean resetForTest(ResetForTestReq req) throws BizException;

    /**
     * 领取月光宝盒奖励
     * @param rewardReq 用户参数、用户定制类型
     * @return 用户奖励数据
     * @throws BizException 业务异常
     */
    PlantDto finishMoonReward(FinishMoonRewardReq rewardReq) throws BizException;

    /**
     * 参与原生活动
     * @param req 用户信息，原生参与次数
     * @return plant
     * @throws BizException 异常
     */
    PlantDto joinNativeActivity(JoinNativeReq req) throws BizException;


    /**
     * 获取用户小额提现阶梯
     * @param commercialUserReq 用户数据
     * @return 小额提现阶梯
     * @throws BizException 参数异常
     */
    PrettyCashStageDto getPrettyStageByUser(CommercialUserReq commercialUserReq) throws BizException;

    /**
     * 更新种子成熟时间
     * @param seedReq 种子id、成熟时间
     * @return 是否成功
     * @throws BizException
     */
    Boolean updateSeedMatureTime(UpdateSeedReq seedReq) throws BizException;


    String updatePlantUser(Integer start, Integer size);
}
