package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 非定值金币占比配置
 */
@Setter
@Getter
public class SynConfigVariableIncomeRatioDTO implements Serializable {

    private static final long serialVersionUID = 249715853821849510L;

    private Long id;

    @ApiModelProperty(value = "配置版本")
    @ExcelRowIndex
    private Integer configVersion;

    @ApiModelProperty(value = "限次活动")
    @ExcelRowIndex(0)
    private Integer activityRatio;

    @ApiModelProperty(value = "限次抽奖")
    @ExcelRowIndex(1)
    private Integer lotteryRatio;

    @ApiModelProperty(value = "每日签到")
    @ExcelRowIndex(2)
    private Integer signRatio;

    @ApiModelProperty(value = "每日任务")
    @ExcelRowIndex(3)
    private Integer missionRatio;

    @ApiModelProperty(value = "天降礼包")
    @ExcelRowIndex(4)
    private Integer heavenGiftRatio;

//    @ApiModelProperty(value = "初始金币")
//    @ExcelRowIndex(5)
//    private Integer originalGold;

    private Date gmtCreate;

    private Date gmtModified;

}
