package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.finance.FarmDoubleConfigDto;

import java.util.List;

/**
 * 【红包农场】媒体配置接口
 *
 * @author zhangbaiqiang
 * @date 2019/12/10
 */
@AdvancedFeignClient
public interface RemoteFarmAppConfigService {

    /**
     * 更新媒体的翻倍弹窗配置
     *
     * @param config 翻倍弹窗配置
     * @return 更新后的翻倍弹窗配置
     */
    FarmDoubleConfigDto updateAppDoubleConfig(FarmDoubleConfigDto config);

    /**
     * 更新媒体白名单
     * @param type 白名单类型
     * @param appId 媒体id
     * @param operateType 操作类型
     * @return 更新后的白名单
     */
    List<Long> updateAndGetAppWhitelist(Integer type, Long appId, Integer operateType) throws BizException;
}
