package cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.invite.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2020/4/9
 * @description: [中青定制] 拉新任务详情Dto
 **/
@Data
@NoArgsConstructor
public class InviteMissionDto implements Serializable {
    /**
     * 任务编号
     */
    private Integer id;

    /**
     * 任务类型
     */
    private String type;

    /**
     * 任务描述
     */
    private String desc;

    /**
     * 图片链接
     */
    private String picUrl;

    /**
     * 任务进度(1/1)
     */
    private String progress;

    /**
     * 当前任务完成数
     */
    private Integer inviteSuccessCount;

    /**
     * 任务完成条件总数
     */
    private Integer conditionAmount;

    /**
     * 状态(0-去邀请 1-获取奖励 9-已领取)
     */
    private Integer status = 0;

    public InviteMissionDto(Integer id, String type, String desc, String picUrl, Integer conditionAmount) {
        this.id = id;
        this.type = type;
        this.desc = desc;
        this.picUrl = picUrl;
        this.conditionAmount = conditionAmount;
    }
}
