package cn.com.duiba.tuia.commercial.center.api.remoteservice.synthesis;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.*;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynRewardReq;

/**
 * 可以选择对类功能进行说明
 * Created by zxw on 2020-06-09.
 */

@AdvancedFeignClient
public interface RemoteSynthesisGiftService {

    /**
     * 渲染大转盘
     *
     * @param activityRequest
     * @return
     */
    SynLotteryDTO getLottery(ActivityRequestDTO activityRequest) throws BizException;

    /**
     * 用户抽奖
     *
     * @param activityRequest
     * @return
     */
    SynLotteryResultDTO drawPrize(ActivityRequestDTO activityRequest) throws BizException;

    /**
     * 处理新人礼包
     *
     * @param activityRequest
     * @return
     */
    SynRewardDTO receiveHeavenGift(ActivityRequestDTO activityRequest) throws BizException;

    /**
     * 处理新人三日礼物
     *
     * @param activityRequest
     * @return
     */
    SynInitCashDTO receiveThirdGifts(ActivityRequestDTO activityRequest) throws BizException;


    /**
     * 处理奖励回调
     *
     * @param rewardReq
     * @return
     */
    SynRewardDTO obtainRewardPrize(SynRewardReq rewardReq) throws BizException;

    /**
     * 读取用户redis里的信息
     *
     * @param activityRequest
     * @return
     */
    SynUserGiftConfigDTO getSynUserGiftConfig(ActivityRequestDTO activityRequest) throws BizException;


    /**
     * 测试用的直接补满接口，生产预发环境别随便用
     *
     * @param activityRequest
     * @return
     * @throws BizException
     */
    SynRewardDTO receiveTestGifts(ActivityRequestDTO activityRequest) throws BizException;


}
