package cn.com.duiba.tuia.commercial.center.api.constant.farm;

import java.util.concurrent.TimeUnit;

/**
 * 缓存空间
 * Created by zxw on 2020-12-03.
 */
public enum CommonCacheKey {

    /**
     * 看视频的次数
     */
    FARM_VIDEO_TIMES("farm_video_times", 1, TimeUnit.DAYS);

    private static final String SPACE = "COMMERCIAL_CENTER";

    /**
     * 缓存key标识 缓存key=TAC-key标识-参数 注意:key不允许重复
     */
    private String key;

    /**
     * 缓存时间
     */
    private int time;

    /**
     * 时间单位
     */
    private TimeUnit unit;

    CommonCacheKey(String key, int time, TimeUnit unit) {
        this.key = key;
        this.time = time;
        this.unit = unit;
    }

    public String getKey() {
        return key;
    }

    public int getTime() {
        return time;
    }

    public TimeUnit getUnit() {
        return unit;
    }

    public String generatorKey(Object... params) {
        StringBuilder sb = new StringBuilder(SPACE + "-");
        sb.append(key);
        if (params != null) {
            for (Object temp : params) {
                sb.append("-");
                sb.append(temp);
            }
        }

        return sb.toString();
    }


}
