package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * [合成游戏]美食图鉴
 */
@Getter
@Setter
public class SynFoodDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "美食序号")
    private Long foodSn;

    @ApiModelProperty(value = "图鉴组ID")
    private Long foodGroupId;

    @ApiModelProperty(value = "图鉴组序号")
    private Long foodGroupSn;

    @ApiModelProperty(value = "美食名称")
    private String foodName;

    @ApiModelProperty(value = "美食标题")
    private String foodTitle;

    @ApiModelProperty(value = "美食副标题")
    private String foodSubtitle;

    @ApiModelProperty(value = "解锁等级")
    private Integer unlockPetGrade;

    @ApiModelProperty(value = "美食奖励")
    private Long foodPrize;

    @ApiModelProperty(value = "气泡文字")
    private String popText;

    @ApiModelProperty(value = "场景名称")
    private String sceneName;

    @ApiModelProperty(value = "场景图片")
    private String sceneImg;

    @ApiModelProperty(value = "美食图片")
    private String foodImg;

    @ApiModelProperty(value = "美食图片(未解锁)")
    private String unlockedFoodImg;

    @ApiModelProperty(value = "配置版本")
    private Integer configVersion;

}