package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.invite;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.invite.dto.InviteDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.invite.req.InviteCallBackReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.invite.req.InviteWithdrawReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2020/4/13
 * @description: [中青定制] 拉新、分享
 **/
@AdvancedFeignClient
public interface RemoteInviteCustomService {

    /**
     * [中青定制] 拉新任务
     * @param req
     * @return
     * @throws BizException
     */
    InviteDto invite(CommercialUserReq req) throws BizException;

    /**
     * [中青定制] 查询拉新总数
     * @param req
     * @return
     * @throws BizException
     */
    int inviteTotal(CommercialUserReq req) throws BizException;

    /**
     * [中青定制] 回调插入订单
     * @param req
     * @throws BizException
     */
    void inviteCallback(InviteCallBackReq req) throws BizException;

    /**
     * [中青定制] 校验是否满足提现条件
     * @param dto
     * @throws BizException
     */
    void preInviteWithdraw(InviteWithdrawReq dto)throws BizException;

    /**
     * [中青定制] 提现
     * @param dto
     * @throws BizException
     */
    void inviteWithdraw(InviteWithdrawReq dto)throws BizException;

    /**
     * [中青定制] 充值接口
     * @param appId
     * @param cash
     * @throws BizException
     */
    void inviteRecharge(Long appId, Integer cash)throws BizException;

}
