package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.richman;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.richman.dto.RichManOrderDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.richman.dto.RichManUserDto;

/**
 * @author scd
 * @version 1.0
 * @since 2019-12-03 17:11
 */
@AdvancedFeignClient
public interface RemoteRichManUserService {


    /**
     * 修改用户的 步数或者天数
     * @param dto
     * @param steps
     * @param day
     */
    RichManUserDto updateUser(RichManUserDto dto,Integer steps,Integer day) throws BizException;

    /**
     * 获取用户信息
     * @param devicId
     * @param appId
     * @return
     */
    RichManUserDto getUserDto(Long appId,String devicId,String mediaUserId) throws BizException;

    /**
     * 添加用户提现记录
     * @param dto
     */
    void addUserOrder(RichManOrderDto dto) throws BizException;

    void retUser(String userId,Long appId) throws BizException;

    /**
     * 获取排名百分比
     * @param userDto
     * @return
     */
    Integer getPrecente(RichManUserDto userDto) throws BizException;

    /**
     * 修改用户标记
     * @param sign
     * @param userDto
     */
    void updateUserSign(Long sign,RichManUserDto userDto) throws BizException;

    /**
     * 修改碎片标记
     * @param userDto
     */
    void updatePatchPrecent(RichManUserDto userDto) throws BizException;
}
