package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.req.FinanceConfigReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmActivityVersionConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmAppBudgetDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.finance.FarmFinanceConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.finance.FarmFinanceConfigInfoDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.finance.FarmFinanceConfigRecordDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance.FarmAppQueryReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance.FarmFinanceConfigReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance.FarmFinanceRecordQueryReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance.FarmVersionConfigReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteFarmFinanceConfigService {

    int delete(Long id);

    int deleteByAppIdAndStage(FinanceConfigReq req) throws BizException;

    int insert(FarmFinanceConfigDto financeConfig) throws BizException;

    int update(FarmFinanceConfigDto financeConfig) throws BizException;

    int addBudget(FarmFinanceConfigDto financeConfig) throws BizException;

    FarmFinanceConfigDto getById(Long id) throws BizException;

    FarmFinanceConfigDto selectByAppIdAndStage(FinanceConfigReq req) throws BizException;


    /**
     * 保存版本配置
     * @param configReq 配置信息、版本
     * @return 是否成功
     */
    Boolean saveVersionConfig(FarmVersionConfigReq configReq) throws BizException ;

    /**
     * 保存活动版本配置
     * @param configDto
     * @return
     * @throws BizException
     */
    Boolean saveActivityConfigVersion(FarmActivityVersionConfigDto configDto) throws BizException;


    /**
     * 活动后台保存配置
     * @param configDto 活动id、版本
     * @return 是否成功
     */
    Integer saveActivityConfigVersionForManager(FarmActivityVersionConfigDto configDto) throws BizException;

    /**
     * 保存预算
     * @param appBudget 预算
     * @return 是否成功
     */
    Boolean saveFarmBudgetConfigDto(FarmAppBudgetDto appBudget) throws BizException;

    /**
     * 后台保存财务模型
     * @param configReq 财务模型
     * @return 是否成功
     */
    Boolean saveFarmFinanceConfig(FarmFinanceConfigReq configReq) throws BizException;

    /**
     * 获取媒体财务模型配置（管理后台）
     * @param appId 媒体id
     * @return 媒体配置
     */
    FarmFinanceConfigInfoDto getAppConfig(Long appId) throws BizException;

    /**
     * 查询媒体财务模型列表
     * @return 媒体列表
     */
    PageResultDto<FarmFinanceConfigInfoDto> getAppFinanceList(FarmAppQueryReq req) throws BizException;

    /**
     * 获取媒体操作记录
     * @param queryReq 媒体id、start、size
     * @return 操作记录
     */
    PageResultDto<FarmFinanceConfigRecordDto> getRecordList(FarmFinanceRecordQueryReq queryReq) throws BizException;

    /**
     * 查询活动版本
     * @param activityId 活动id
     * @return 版本号
     */
    Integer getVersionByActivityId(Long activityId) throws BizException;

    /**
     * 获取活动版本列表
     * @return 活动列表
     */
    List<Integer> getActivityVersionList() throws BizException;

    /**
     * 媒体是否存在
     * @param appId
     * @return
     */
    Boolean isAppExist(Long appId) throws BizException;
}
