package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * FarmDto
 *
 * @author huangruodan
 * @date 2019-11-21
 */

@Data
public class FarmDto implements Serializable {

    private static final long serialVersionUID = 5371304900470723994L;

    private FarmInitializeUserDto user;

    private List<FarmLandDto> land;

    private List<FarmMissionDto> mission;

    private List<FarmFacilityDto> farm;

    private List<FarmUserPropInfosDto> propInfo;

    private FarmWaterDto waterConfig;

    private List<FarmPacketDto> conversion;

    private List<FarmSignInfoDto> signInfoDtos;

    private List<FarmPacketDetailDto> packetDetailDtos;

    private List<FarmAchievementDetailDto> userAchievements;

    /**
     * 用户奖励信息
     */
    private FarmFinanceRewardDto reward;

    /**
     * 神秘访客
     */
    private FarmEventDto visitorEvent;

    /**
     * 打地鼠
     */
    private FarmEventDto mouseEvent;

    /**
     * 果实库
     */
    private List<FarmFruitConfigDto> fruitLib;

    private List<FarmDoubleRewardResultDto> doubleRewardList;

    private List<FarmBeginGiftDto> beginGiftDtos;

    /**
     * 激励视频开关 0-关 1-开
     */
    private Integer openRewardVideo;


    /**
     * 下次一键收获的时间
     */
    private Date nextAllPickTime;

    /**
     * 贡献任务
     */
    private List<FarmContributionUserMissionDto> contributionMissions;

    /**
     * 新人礼第几天
     */
    private Integer beginGiftDays;

    /**
     * 累计收获奖励
     */
    private FarmCumulativePickAwardDto cumulativePickAwardDto;

}
