package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmAchievementDetailDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmAchievementReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteFarmAchievementService {

    /*
    得到用户对应的成就列表
   */
    List<FarmAchievementDetailDto> getAchievementList(FarmUserReq farmUserReq) throws BizException;

    /*
    更新并得到用户对应的成就列表
   */
    List<FarmAchievementDetailDto> updateAndGetAchievementList(FarmUserReq farmUserReq) throws BizException;

    /*
    佩戴奖章
     */
    List<FarmAchievementDetailDto> wearMedal(FarmAchievementReq farmAchievementReq) throws BizException;

    /*
    成就奖章状态修改
     */
    void showModal(FarmAchievementReq farmAchievementReq) throws BizException;

}
