package cn.com.duiba.tuia.commercial.center.api.remoteservice.synthesis;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.ActivityRequestDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.SynActivityConfigDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.SynConfigActivityVersionDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.SynConfigGiftDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.SynWithdrawPrizeDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynConfigFinanceReqDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynVersionConfigReq;

import java.util.List;

/**
 * @author lijicong
 * @since 2020-05-29
 */
@AdvancedFeignClient
public interface RemoteSynthesisConfigService {

    // 媒体纬度相关

    SynConfigGiftDTO getGiftConfig(Long appId) throws BizException;

    boolean setGiftConfig(SynConfigGiftDTO giftDTO) throws BizException;

    SynConfigFinanceReqDTO getFinanceConfig(Long appId) throws BizException;

    boolean setFinanceConfig(SynConfigFinanceReqDTO financeReq) throws BizException;

    // excel数值表相关

    Integer saveExcelSynthesisConfigAsynchronousLy(SynVersionConfigReq configReq) throws BizException;

    Integer deleteExcelSynthesisConfigAsynchronousLy(Integer configVersion) throws BizException;

    Boolean saveActivityConfigVersion(Long activityId, Integer configVersion) throws BizException;

    Boolean deleteActivityConfigVersion(Long activityId) throws BizException;

    SynConfigActivityVersionDTO querySynConfigActivityVersion(Long activityId) throws BizException;

    // 除excel之外，活动纬度相关

    SynActivityConfigDTO getActivityConfig(Long activityId) throws BizException;

    boolean setActivityConfig(SynActivityConfigDTO configDTO) throws BizException;

    List<SynWithdrawPrizeDTO> prizeList(ActivityRequestDTO activityRequest) throws BizException;
}
