package cn.com.duiba.tuia.commercial.center.api.remoteservice.synthesis;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.ActivityRequestDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.SynthesisDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynBuyReqDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynBuyRespDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynCompoundGiftRespDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynCompoundReqDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynCompoundRespDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynRecycleReqDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynReportReqDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynRewardRespDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynSwapReqDTO;

/**
 * 合成游戏-宠物玩法接口
 * @author lijicong
 * @since 2020-05-29
 */
@AdvancedFeignClient
public interface RemoteSynthesisService {

    /**
     * 初始接口
     * @param activityRequest
     * @return
     * @throws BizException
     */
    SynthesisDTO initialize(ActivityRequestDTO activityRequest, SynReportReqDTO synReportReq) throws BizException;

    /**
     * 新手引导-更新引导进度
     * @param activityRequest
     * @return
     * @throws BizException
     */
    Boolean updateGuideStep(ActivityRequestDTO activityRequest) throws BizException;

    /**
     * 领取新手奖励
     * @param activityRequest
     * @return
     * @throws BizException
     */
    SynRewardRespDTO receiveNoviceRewards(ActivityRequestDTO activityRequest) throws BizException;

    /**
     * 购买宠物
     * @param activityRequest
     * @param synBuyReq
     * @return
     * @throws BizException
     */
    SynBuyRespDTO buy(ActivityRequestDTO activityRequest, SynBuyReqDTO synBuyReq) throws BizException;

    /**
     * 合成宠物
     * @param activityRequest
     * @param synCompoundReq
     * @return
     * @throws BizException
     */
    SynCompoundRespDTO compound(ActivityRequestDTO activityRequest, SynCompoundReqDTO synCompoundReq) throws BizException;

    /**
     * 打开/领取礼包
     * @param activityRequest
     * @param giftCode
     * @return
     * @throws BizException
     */
    SynCompoundGiftRespDTO openGfit(ActivityRequestDTO activityRequest, String giftCode) throws BizException;

    /**
     * 回收宠物
     * @param activityRequest
     * @param synRecycleReq
     * @return
     * @throws BizException
     */
    Boolean recycle(ActivityRequestDTO activityRequest, SynRecycleReqDTO synRecycleReq) throws BizException;

    /**
     * 交换顺序
     * @param activityRequest
     * @param synSwapReq
     * @return
     */
    Boolean swap(ActivityRequestDTO activityRequest, SynSwapReqDTO synSwapReq) throws BizException;

    /**
     * 上报/同步信息接口
     * @param activityRequest
     * @return
     * @throws BizException
     */
    SynthesisDTO report(ActivityRequestDTO activityRequest, SynReportReqDTO synReportReq) throws BizException;

}
