package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 贡献任务配置
 * Created by zxw on 2021-01-05.
 */
@Getter
@Setter
public class FarmContributionConfigDto implements Serializable {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "整体预算")
    private Integer totalBudget;

    @ApiModelProperty(value = "每日预算-基准值")
    private Integer dailyBudget;

    @ApiModelProperty(value = "每日预算上限")
    private Integer dailyBudgetMax;

    @ApiModelProperty(value = "预算每日发放占比")
    private Integer dailyBudgetRantRatio;

    @ApiModelProperty(value = "预期每日消耗占比")
    private Integer dailyBudgetExpectRation;

    @ApiModelProperty(value = "可使用的贡献占比")
    private Integer contributionBudget;

    @ApiModelProperty(value = "贡献上限")
    private Integer contributionMax;

    @ApiModelProperty(value = "任务发放占比-基准值")
    private Integer rantRation;

    @ApiModelProperty(value = "用户登录N天后开始发放任务")
    private Integer startDay;

    @ApiModelProperty(value = "追加库存")
    private Integer addStock;
}
