package cn.com.duiba.tuia.commercial.center.api.dto.farm.excel;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 可以选择对类功能进行说明
 * Created by zxw on 2021-03-09.
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class FarmExcelLevelConfigDto implements Serializable {


    @ApiModelProperty(value = "id")
    @ExcelRowIndex
    private Long id;

    @ApiModelProperty(value = "等级")
    @ExcelRowIndex(1)
    private Integer levelNum;

    @ApiModelProperty(value = "需要的经验")
    @ExcelRowIndex(2)
    private Long needExp;

    @ApiModelProperty(value = "基础奖励倍率")
    @ExcelRowIndex(3)
    private Long baseAward;

    @ApiModelProperty(value = "每日奖励倍率")
    @ExcelRowIndex(4)
    private Long dailyAward;


}
