package cn.com.duiba.tuia.commercial.center.api.dto.farm.excel;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;


/**
 * 限次抽奖配置DTO
 */
@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class FarmExcelLotteryConfigDTO implements Serializable {

    @ApiModelProperty(value = "奖品序号")
    @ExcelRowIndex
    private Integer lotterySerialNumber;

    @ApiModelProperty(value = "奖品名称")
    @ExcelRowIndex(1)
    private String lotteryName;

    @ApiModelProperty(value = "奖品类型 1:金币奖励 2:金币宝箱")
    @ExcelRowIndex(2)
    private Integer lotteryType;

    @ApiModelProperty(value = "概率")
    @ExcelRowIndex(3)
    private Integer lotteryProb;

    @ApiModelProperty(value = "系数")
    @ExcelRowIndex(4)
    private Integer lotteryFactor;

    @ApiModelProperty(value = "奖品图片")
    @ExcelRowIndex(5)
    private String lotteryImg;

    private Date gmtCreate;

    private Date gmtModified;

}
