package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.richman;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.req.RichManReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.richman.dto.RichManSignActivityConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.richman.RichManSignDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRichManSignService {

    RichManSignDto getSignList(RichManReq richManReq) throws BizException;

    Boolean resetLastSignTiem(RichManReq richManReq) throws BizException;

    Boolean addActivityConfig(List<RichManSignActivityConfigDto> dtoList, Long activityId) throws BizException;

    Boolean updateActivityConfig(List<RichManSignActivityConfigDto> dtoList, Long activityId) throws BizException;

    Boolean addOrUpdateActivityConfig(List<RichManSignActivityConfigDto> dtoList, Long activityId) throws BizException;

    Boolean deleteActivityConfig(Long activityId, Integer signDay) throws BizException;

    List<RichManSignActivityConfigDto> getActivityConfig(Long activityId, Integer signDay) throws BizException;
}
