package cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 抽奖配置
 * Created by zxw on 2021-05-27.
 */


@Getter
@Setter
public class SpreadActivityConfigDto implements Serializable {

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "活动id")
    private Long activityId;

    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    @ApiModelProperty(value = "免费次数")
    private Integer freeTimes;

    @ApiModelProperty(value = "额外次数")
    private Integer extraTimes;

    @ApiModelProperty(value = "额外次数所需费用")
    private Integer needFee;

    @ApiModelProperty(value = "免费抽奖  碎片区间")
    private String freeRegion;

    @ApiModelProperty(value = "付费抽奖  碎片区间")
    private String extraRegion;

    @ApiModelProperty(value = "付费抽奖  碎片区间")
    private String seniorCoinName;
    /**
     * 实物抽奖配置
     */
    private JackpotConfigDto jackpotConfig;
    /**
     * 兑换配置
     */
    private List<ExchangeConfig> exchangeConfig;

    /**
     * 兑换配置
     */
    private List<Integer> signList;


    @ApiModelProperty(value = "免费抽奖  碎片区间")
    private List<Integer> freeRegions;

    @ApiModelProperty(value = "免费抽奖  碎片区间")
    private List<Integer> extraRegions;


    @Getter
    @Setter
    public class ExchangeConfig {

        private Long prizeId;

        private Integer needCoin;

        private Integer warnCoin;
    }





}
