package cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 推广活动Dto
 */
@Getter
@Setter
@SuppressWarnings("serial")
public class SpreadDto implements Serializable {

    private static final long serialVersionUID = -4938423994925379010L;

    @ApiModelProperty(value = "用户信息")
    private SpreadActivityUserDto user;

    @ApiModelProperty(value = "免费次数")
    private Integer freeTimes;

    @ApiModelProperty(value = "额外次数")
    private Integer extraTimes;

    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    @ApiModelProperty(value = "签到奖励列表")
    private List<Integer> signList;

    @ApiModelProperty(value = "兑换列表")
    private List<ExchangePrizeDto> exchangeList;
}