package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 可以选择对类功能进行说明
 * Created by zxw on 2020-06-03.
 */

@Data
public class SynUserExtDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "用户ID")
    private Long baseUserId;

    @ApiModelProperty(value = "媒体ID")
    private Long appId;

    @ApiModelProperty(value = "累计登录天数")
    private Integer cumulativeLogin;

    @ApiModelProperty(value = "签到天数（7天1个周期）")
    private Integer checkInDays;

    @ApiModelProperty(value = "今日初始等级")
    private Integer curGrade;

    @ApiModelProperty(value = "每日已得到新等级可得到的金额")
    private Integer curNewAmount;

    @ApiModelProperty(value = "每日已得到合成可得到的金额")
    private Integer curNormalAmount;

    @ApiModelProperty(value = "每日新等级可得到的金额")
    private Integer newAmount;

    @ApiModelProperty(value = "每日合成可得到的金额")
    private Integer normalAmount;

    @ApiModelProperty(value = "今日抽奖次数")
    private Integer curDrawNum;

    @ApiModelProperty(value = "今日限次活动次数")
    private Integer curLimitTime;

    @ApiModelProperty(value = "今日离线翻倍次数")
    private Integer offlineRevenueDouble;

    @ApiModelProperty(value = "累计打开礼物n次")
    private Integer curGiftNum;

    @ApiModelProperty(value = "今日卷曝光次数")
    private Integer curExposureNum;

    @ApiModelProperty(value = "礼包打开N次出现金")
    private Integer synToMoney;

    @ApiModelProperty(value = "现金翻倍次数")
    private Integer cashDouble;

    @ApiModelProperty(value = "现金初始值(新手指引红包，三日红包)")
    private SynInitCashDTO initCash;

    @ApiModelProperty(value = "已完成的任务列表")
    private SynUserMissionDTO finishMission;

    @ApiModelProperty(value = "最新登录日期")
    private Date loginDate;

    /**
     * 单独渲染下新人三日礼，别的数据不要了
     *
     * @return
     */
    public SynInitCashDTO getThirdGift(Date today) {
        SynInitCashDTO initCash = this.getInitCash();
        SynInitCashDTO thirdGift = SynInitCashDTO.builder()
                .step(initCash.getStep())
                .newCash(initCash.getNewCash())
                .build();
        if (initCash.getDate() == null) {
            thirdGift.setIsReceived(Boolean.FALSE);
        } else {
            thirdGift.setIsReceived(today.before(initCash.getDate()));
        }
        return thirdGift;

    }
}
