package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.richman;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.richman.dto.RichManPatchDto;

import java.util.List;

/**
 * @author scd
 * @version 1.0
 * @since 2020-01-09 10:22
 */
@AdvancedFeignClient
public interface RemoteRichManPatchService {

    /**
     * 根据城市name获取碎片配置
     * @param dto
     * @return
     */
    List<RichManPatchDto> getListByCityName(RichManPatchDto dto) throws BizException;

    /**
     * 获取最新的碎片位置计算百分比
     * @param actvitiyId
     * @param city
     * @param steps
     * @return
     */
    RichManPatchDto getBeforePatchs(Long actvitiyId,String city,Long steps) throws BizException;

    /**
     * 测试添加碎片
     * @param dto
     */
    void addPatchDto(RichManPatchDto dto) throws BizException;

}
