package cn.com.duiba.tuia.commercial.center.api.remoteservice.spread;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread.SpreadDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread.SpreadLotteryResultDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread.SpreadMissionUserDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread.SpreadRecordDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread.req.SpreadExchangeReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread.req.SpreadMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.ActivityRequestDTO;

import java.util.List;
import java.util.Map;

/**
 * RemoteSpreadService
 * Created by zxw on 2021-06-02.
 */

@AdvancedFeignClient
public interface RemoteSpreadService {

    /**
     * 初始化接口
     *
     * @param req
     * @return
     * @throws BizException
     */
    SpreadDto initialize(ActivityRequestDTO req) throws BizException;

    /**
     * 抽奖
     *
     * @param activityRequestDTO
     * @return
     */
    SpreadLotteryResultDto join(ActivityRequestDTO activityRequestDTO) throws BizException;

    /**
     * 完成任务
     *
     * @param req
     * @return
     */
    Integer finishMission(SpreadMissionReq req) throws BizException;

    /**
     * 签到
     *
     * @param req
     * @return
     */
    Integer doSign(ActivityRequestDTO req) throws BizException;

    /**
     * 查询中奖流水跑马灯
     *
     * @param req
     * @return
     */
    List<SpreadRecordDto> getRecordList(ActivityRequestDTO req);


    /**
     * @param req
     * @return
     */
    Map<Integer, List<SpreadMissionUserDto>> getMission(ActivityRequestDTO req);


    /**
     * 兑换打tag
     *
     * @param req
     * @return
     * @throws BizException
     */
    SpreadLotteryResultDto exchange(SpreadExchangeReq req) throws BizException;


    /**
     * 查询个人兑换记录
     *
     * @param req
     * @return
     */
    List<SpreadRecordDto> getPersonalExchange(ActivityRequestDTO req);
}
