package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 农场用户等级财务模型配置
 */
@Getter
@Setter
@SuppressWarnings("serial")
@AllArgsConstructor
@NoArgsConstructor
public class FarmLevelFinanceConfigDTO implements Serializable {

    @ApiModelProperty(value = "媒体id")
    private Long id;

    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "最高金额")
    private Integer maxNum;

    @ApiModelProperty(value = "最高发放比例")
    private Integer maxRation;

    @ApiModelProperty(value = "每日预算最高发放比例")
    private Integer dailyMaxRation;

    @ApiModelProperty(value = "每日预算最低发放比例")
    private Integer dailyMinRation;

    @ApiModelProperty(value = "每日预算最高金额")
    private Integer dailyMax;

    @ApiModelProperty(value = "单个红包最大比例")
    private Integer singleMaxRation;

    @ApiModelProperty(value = "单个红包最小比例")
    private Integer singleMinRation;

    @ApiModelProperty(value = "经验收益时间上限")
    private Integer expMaxTime;
}