package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.common;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.PrettyWithdrawRecordDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.WithdrawRecordDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.req.PrettyWithdrawRecordQueryReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWithdrawRecordService {

    List<WithdrawRecordDto> selectByUserId(Long userId);

    int insert(WithdrawRecordDto withDrawRecordDto);

    int update(WithdrawRecordDto withDrawRecordDto);

    /**
     * 查询用户指定提现周期的订单号
     *
     * @param req 用户参数
     * @return 订单号
     */
    String selectOrder(CommercialUserReq req);


    List<WithdrawRecordDto> selectBy(CommercialUserReq req);

    /**
     * 根据用户阶梯查询用户小额提现记录
     * @param req  用户id、阶梯、小额提现阶梯
     * @return 提现记录
     * @throws BizException 参数异常
     */
    PrettyWithdrawRecordDto selectPrettyRecordByUserInfo(PrettyWithdrawRecordQueryReq req) throws BizException;
}
