package cn.com.duiba.tuia.commercial.center.api.dto.farm.common;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * 农场用户高级货币获取log表
 */
@Getter
@Setter
@SuppressWarnings("serial")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class FarmUserCashLogDto implements Serializable {
    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "用户id")
    private Long baseUserId;

    @ApiModelProperty(value = "高级货币数量")
    private Integer seniorCurrency;

    @ApiModelProperty(value = "创建日期str")
    private String createDate;

    public void setCreateDate(String createDate) {
        this.createDate = createDate == null ? null : createDate.trim();
    }
}