package cn.com.duiba.tuia.commercial.center.api.dto.travel;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @ClassName TravelUserMissionDTO
 * @Description
 * @Author zaizai
 * @Date 2021/8/18 5:43 下午
 */
public class TravelUserMissionDTO implements Serializable {

    private static final long serialVersionUID = 8053314471795567334L;

    @ApiModelProperty("任务编码")
    private String missionCode;

    @ApiModelProperty("任务类型 1001-每日任务，次日刷新重置 1002-每周任务，周一刷新重置 1003-历程任务，不重置")
    private Integer missionType;

    @ApiModelProperty("条件类型")
    private String conditionType;

    @ApiModelProperty("图片")
    private String photoUrl;

    @ApiModelProperty("任务描述")
    private String missionDesc;

    @ApiModelProperty("任务状态")
    private Integer missionState;

    @ApiModelProperty("任务奖励")
    private TravelAwardDTO missionAward;

    @ApiModelProperty("当前进度")
    private TravelProgressDTO travelProgressDTO;

    @ApiModelProperty("展示状态 0-不在任务列表展示 1-在任务列表展示")
    private Integer showStatus;

    @ApiModelProperty("任务组类 1-个人任务 2-团队任务")
    private Integer missionGroup;

    @ApiModelProperty("完成条件")
    private String completeCondition;

    @ApiModelProperty("任务顺序")
    private Integer missionSort;

    @ApiModelProperty("任务完成时间戳 秒级")
    private Long completeTimeStamp;

    public String getMissionCode() {
        return missionCode;
    }

    public void setMissionCode(String missionCode) {
        this.missionCode = missionCode;
    }

    public Integer getMissionType() {
        return missionType;
    }

    public void setMissionType(Integer missionType) {
        this.missionType = missionType;
    }

    public String getConditionType() {
        return conditionType;
    }

    public void setConditionType(String conditionType) {
        this.conditionType = conditionType;
    }

    public String getPhotoUrl() {
        return photoUrl;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public String getMissionDesc() {
        return missionDesc;
    }

    public void setMissionDesc(String missionDesc) {
        this.missionDesc = missionDesc;
    }

    public Integer getMissionState() {
        return missionState;
    }

    public void setMissionState(Integer missionState) {
        this.missionState = missionState;
    }

    public TravelAwardDTO getMissionAward() {
        return missionAward;
    }

    public void setMissionAward(TravelAwardDTO missionAward) {
        this.missionAward = missionAward;
    }

    public TravelProgressDTO getTravelProgressDTO() {
        return travelProgressDTO;
    }

    public void setTravelProgressDTO(TravelProgressDTO travelProgressDTO) {
        this.travelProgressDTO = travelProgressDTO;
    }

    public Integer getShowStatus() {
        return showStatus;
    }

    public void setShowStatus(Integer showStatus) {
        this.showStatus = showStatus;
    }

    public Integer getMissionGroup() {
        return missionGroup;
    }

    public void setMissionGroup(Integer missionGroup) {
        this.missionGroup = missionGroup;
    }

    public String getCompleteCondition() {
        return completeCondition;
    }

    public void setCompleteCondition(String completeCondition) {
        this.completeCondition = completeCondition;
    }

    public Integer getMissionSort() {
        return missionSort;
    }

    public void setMissionSort(Integer missionSort) {
        this.missionSort = missionSort;
    }

    public Long getCompleteTimeStamp() {
        return completeTimeStamp;
    }

    public void setCompleteTimeStamp(Long completeTimeStamp) {
        this.completeTimeStamp = completeTimeStamp;
    }
}
