package cn.com.duiba.tuia.commercial.center.api.dto.travel.config;

import cn.tuia.mango.core.domain.BaseDomain;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 环游世界地点信息表
 */
@Getter
@Setter
@SuppressWarnings("serial")
public class TravelAddressConfigDTO implements Serializable {
    @ApiModelProperty(value = "地点编号")
    private String addressCode;

    @ApiModelProperty(value = "父级地点编号")
    private String parentCode;

    @ApiModelProperty(value = "地点名称")
    private String addressName;

    @ApiModelProperty(value = "产出上限配置")
    private String outputCeilConfig;

    @ApiModelProperty(value = "地点类型 -1地图起点 0-城市起点 1-普通 2-城市终点")
    private Integer addressType;

    @ApiModelProperty(value = "地点属性 1城市 2景点 3美食 4文化馆")
    private Integer addressProp;

    @ApiModelProperty(value = "解锁条件")
    private String unlockCondition;

    @ApiModelProperty(value = "解锁奖励")
    private String unlockAward;

    @ApiModelProperty(value = "上一个地区编码")
    private String lastAddressCode;

    @ApiModelProperty(value = "地址介绍")
    private String addressDesc;

    @ApiModelProperty(value = "最高等级")
    private Integer levelCeil;

    @ApiModelProperty(value = "配置版本")
    private Integer configVersion;

    public void setAddressCode(String addressCode) {
        this.addressCode = addressCode == null ? null : addressCode.trim();
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode == null ? null : parentCode.trim();
    }

    public void setAddressName(String addressName) {
        this.addressName = addressName == null ? null : addressName.trim();
    }

    public void setOutputCeilConfig(String outputCeilConfig) {
        this.outputCeilConfig = outputCeilConfig == null ? null : outputCeilConfig.trim();
    }

    public void setUnlockCondition(String unlockCondition) {
        this.unlockCondition = unlockCondition == null ? null : unlockCondition.trim();
    }

    public void setUnlockAward(String unlockAward) {
        this.unlockAward = unlockAward == null ? null : unlockAward.trim();
    }

    public void setLastAddressCode(String lastAddressCode) {
        this.lastAddressCode = lastAddressCode == null ? null : lastAddressCode.trim();
    }

    public BuildOutputCeil getOutputCeil() {
        return JSONObject.parseObject(outputCeilConfig, BuildOutputCeil.class);
    }

    public CityUnlockCondition getCityUnlockCondition() {
        return JSONObject.parseObject(unlockCondition, CityUnlockCondition.class);
    }

    public TravelCoinDTO getUnlockAwardDTO() {
        return JSONObject.parseObject(unlockAward, TravelCoinDTO.class);
    }

    @Getter
    @Setter
    public static class BuildOutputCeil {

        /**
         * 奖励类型
         */
        private Integer awardType;

        /**
         * 数量上限
         */
        private Integer amountCeil;
    }

    @Getter
    @Setter
    public static class CityUnlockCondition {

        /**
         * 开放时间
         */
        private Long openTimeStamp;
    }

    @Setter
    @Getter
    public static class TravelCoinDTO {

        private Integer coinType;

        private Long coinAmount;
    }
}