package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;

/**
 * [红包农场]抽奖配置
 */
@Getter
@Setter
@SuppressWarnings("serial")
@AllArgsConstructor
@NoArgsConstructor
public class FarmLotteryConfigDto implements Serializable {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "配置版本")
    private Integer configVersion;

    @ApiModelProperty(value = "奖品序号")
    private Integer lotterySerialNumber;

    @ApiModelProperty(value = "奖品名称")
    private String lotteryName;

    @ApiModelProperty(value = "奖品类型")
    private Integer lotteryType;

    @ApiModelProperty(value = "奖励系数")
    private Integer lotteryFactor;

    @ApiModelProperty(value = "概率")
    private Integer lotteryProb;

    @ApiModelProperty(value = "奖品图片")
    private String lotteryImg;

    public void setLotteryName(String lotteryName) {
        this.lotteryName = lotteryName == null ? null : lotteryName.trim();
    }

    public void setLotteryImg(String lotteryImg) {
        this.lotteryImg = lotteryImg == null ? null : lotteryImg.trim();
    }
}