package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.Data;

import java.io.Serializable;

/**
 * FarmRandomEventConfigDto
 *
 * @author huangruodan
 * @date 2020-01-20
 */

@Data
public class FarmRandomEventConfigDto implements Serializable {

    private static final long serialVersionUID = -2010764486481704057L;
    /**
     * 事件类型
     */
    private Integer eventType;

    /**
     * 出现次数
     */
    private Integer appearOpportunity;

    /**
     * 概率
     */
    private Double appearRate;

    /**
     * 每日次数上限
     */
    private Integer appearTimes;

    /**
     * 左区间
     */
    private Integer minAppearTimes;

    /**
     * 右区间
     */
    private Integer maxAppearTimes;

    /**
     * 在用户解锁X块土地之前，翻倍弹窗不出现；在土地解锁X块土地后，按照次数阶梯概率出现翻倍弹窗（次数从解锁后重新累积）
     */
    private Integer unlockLand;

    /**
     * 版本配置
     */
    private Integer configVersion;

    /**
     * 出现天数m
     */
    private Integer appearDays;

    /**
     * 上浮比例
     */
    private Double moleFloatRate;

    /**
     * 比例
     */
    private Double moleRate;

    private Integer disappearTime;

    private String imageUrl;

    private Integer conditionType;

    /**
     * 金币下限
     */
    private Double minCashRate;

    /**
     * 奖励系数
     */
    private Double prizeCoefficient;

    /**
     * 地鼠出券概率/翻倍间隔次数
     */
    private Double couponRate;
}
