package cn.com.duiba.tuia.commercial.center.api.dto.travel;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName TravelUserAnchorDTO
 * @Description
 * @Author zaizai
 * @Date 2021/8/9 4:47 下午
 */
public class TravelUserAnchorDTO implements Serializable {

    private static final long serialVersionUID = -7931585389296453137L;

    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("关联主播id")
    private Long anchorId;

    @ApiModelProperty("所处城市code")
    private String cityCode;

    @ApiModelProperty("所处建筑code")
    private String buildCode;

    @ApiModelProperty("低级货币数量")
    private Long totalLowCoin;

    @ApiModelProperty("高级货币数量（用户维度）")
    private Long totalSeniorCoin;

    @ApiModelProperty("解锁建筑总等级（用户解锁建筑等级和）")
    private Long totalBuildingLevel;

    @ApiModelProperty("上次解锁时间")
    private Date lastUnlockTime;

    @ApiModelProperty("是否是新用户（是否从未加入过该主播粉丝团）")
    private Boolean isNewUser;

    @ApiModelProperty("主播粉丝团启动资金")
    private Long startUpAmount;

    @ApiModelProperty("是否发生了主播切换")
    private Boolean isSwitchAnchor;

    @ApiModelProperty("用户新手引导步数")
    private Integer newUserStep;

    @ApiModelProperty("签到状态 1-当日可签到 2可补签 0不可签到")
    private Integer signStatus;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAnchorId() {
        return anchorId;
    }

    public void setAnchorId(Long anchorId) {
        this.anchorId = anchorId;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getBuildCode() {
        return buildCode;
    }

    public void setBuildCode(String buildCode) {
        this.buildCode = buildCode;
    }

    public Long getTotalLowCoin() {
        return totalLowCoin;
    }

    public void setTotalLowCoin(Long totalLowCoin) {
        this.totalLowCoin = totalLowCoin;
    }

    public Long getTotalSeniorCoin() {
        return totalSeniorCoin;
    }

    public void setTotalSeniorCoin(Long totalSeniorCoin) {
        this.totalSeniorCoin = totalSeniorCoin;
    }

    public Long getTotalBuildingLevel() {
        return totalBuildingLevel;
    }

    public void setTotalBuildingLevel(Long totalBuildingLevel) {
        this.totalBuildingLevel = totalBuildingLevel;
    }

    public Date getLastUnlockTime() {
        return lastUnlockTime;
    }

    public void setLastUnlockTime(Date lastUnlockTime) {
        this.lastUnlockTime = lastUnlockTime;
    }

    public Boolean getIsNewUser() {
        return isNewUser;
    }

    public void setIsNewUser(Boolean isNewUser) {
        this.isNewUser = isNewUser;
    }

    public Long getStartUpAmount() {
        return startUpAmount;
    }

    public void setStartUpAmount(Long startUpAmount) {
        this.startUpAmount = startUpAmount;
    }

    public Boolean getIsSwitchAnchor() {
        return isSwitchAnchor;
    }

    public void setIsSwitchAnchor(Boolean switchAnchor) {
        isSwitchAnchor = switchAnchor;
    }

    public Integer getNewUserStep() {
        return newUserStep;
    }

    public void setNewUserStep(Integer newUserStep) {
        this.newUserStep = newUserStep;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
}
