package cn.com.duiba.tuia.commercial.center.api.dto.commercial.spread;

import cn.tuia.mango.core.domain.BaseDomain;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 推广活动奖励配置表
 */
@Getter
@Setter
@SuppressWarnings("serial")
@AllArgsConstructor
@NoArgsConstructor
public class SpreadPrizeConfigDto extends BaseDomain {
    @ApiModelProperty(value = "媒体id")
    private Long appId;

    @ApiModelProperty(value = "活动id")
    private Long activityId;

    @ApiModelProperty(value = "奖品id")
    private Long prizeId;

    @ApiModelProperty(value = "总插件id  为空代表不需要发奖")
    private Long pluginId;

    @ApiModelProperty(value = "总库存")
    private Integer totalStock;

    @ApiModelProperty(value = "每日库存")
    private Integer dailyStock;

    @ApiModelProperty(value = "当前剩余库存")
    private Integer currentStock;

    @ApiModelProperty(value = "奖励描述")
    private String prizeDesc;

    @ApiModelProperty(value = "奖励图片")
    private String prizePic;

    @ApiModelProperty(value = "追加的库存")
    private Integer addStock;

    public void setPrizeDesc(String prizeDesc) {
        this.prizeDesc = prizeDesc == null ? null : prizeDesc.trim();
    }

    public void setPrizePic(String prizePic) {
        this.prizePic = prizePic == null ? null : prizePic.trim();
    }
}