package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.FarmFacilityExtInfoDto;
import lombok.Data;

import java.io.Serializable;

/**
 * 设施信息
 * Created by xuefeng on 2019/11/27.
 */
@Data
public class FarmFacilityDto implements Serializable {

    private static final long serialVersionUID = -5128448496347620160L;

    /**
     * 设施类型
     */
    private Integer facilityType;


    /**
     * 设施名称
     */
    private String facilityName;

    /**
     * 等级
     */
    private Integer facilityLevel;

    /**
     * 奖励数量
     */
    private Integer prizeAmount;

    /**
     * 其他奖励数量（JSON数组)
     */
    private String prizeAmountExt;

    /**
     * 奖励上限
     */
    private Integer upperLimit;

    /**
     * 升级消耗金币数
     */
    private Integer cashUpgrade;

    /**
     * 奖励周期
     */
    private Integer prizePeriod;

    /**
     * 冷却时长（s）
     */
    private Integer coolDown;

    /**
     * 图片url
     */
    private String imageUrl;

    /**
     * 升级时间，用英文‘;’分隔
     */
    private String upgradeDate;

    /**
     * 设施状态 0:未解锁 1:解锁生效 2:解锁未生效（冷却）
     */
    private Integer status;

    /**
     * 当前周期剩余时长，单位s
     */
    private Integer periodLeftTime;

    /**
     * 未领取的金币
     */
    private Long unclearedCash;

    /**
     * 奖励系数
     */
    private Double prizeCoefficient;

    /**
     * 未领取的红包
     */
    private Integer unclearedRedPacket;

    /**
     * 下一级配置
     */
    private FarmFacilityDto nextLevelDto;

    /**
     * 扩展信息
     */
    private FarmFacilityExtInfoDto extInfo;
}
