package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * [合成游戏]用户表
 */
@Getter
@Setter
public class SynUserDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "宠物最高等级")
    private Integer topGrade;

    @ApiModelProperty(value = "金币增长速度（每秒）")
    private Long growRate;

    @ApiModelProperty(value = "宠物收益")
    private Long coin;

    @ApiModelProperty(value = "用户宠物")
    private List<UserPetDTO> userPets;

    @ApiModelProperty(value = "当前等级宠物购买次数")
    private Integer buyPetCount;

    @ApiModelProperty(value = "是否新手用户")
    private Boolean isNew;

    @ApiModelProperty(value = "新手引导步骤")
    private Integer guideStep;

    @ApiModelProperty(value = "上次操作时间")
    private Date lastOperateTime;


    @Getter
    @Setter
    public static class UserPetDTO implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "宠物ID")
        private Integer petId;

        @ApiModelProperty(value = "宠物等级")
        private Integer petGrade;

        @ApiModelProperty(value = "宠物位置")
        private Integer petPosition;
    }

}