package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * @author lijicong
 * @since 2020-05-27
 */
@Setter
@Getter
public class SynthesisDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户信息")
    private SynUserDTO user;

    @ApiModelProperty(value = "用户信息")
    private OfflineGoldDTO offlineGold;

    @ApiModelProperty(value = "宠物信息")
    private List<SynPetDTO> pets;

    @ApiModelProperty(value = "用户信息")
    private QuickBuyInfoDTO quickBuyInfo;

    @Setter
    @Getter
    public static class QuickBuyInfoDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "可购宠物ID")
        private Long buyPetId;

        @ApiModelProperty(value = "可购宠物等级")
        private Integer buyPetGrade;

        @ApiModelProperty(value = "基础金币")
        private Long petPrice;
    }

    @Setter
    @Getter
    public static class OfflineGoldDTO implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long offlineTime;
        private Long coin;

    }
}
