package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.tree;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission.req.FinishMissionReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.PickReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.PlantReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.req.ResetForTestReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.tree.TreeAlbumDetailDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.tree.TreeDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.tree.finance.TreeRewardDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.tree.req.PlantTreeReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.user.req.CommercialUserReq;

/**
 * RemoteCommercialTreeService
 *
 * @author huangruodan
 * @date 2019-08-12
 */

@AdvancedFeignClient
public interface RemoteCommercialTreeService {

    /**
     * 签到
     * @param req 用户参数
     * @return 用户信息、土地信息、种子仓库、签到信息
     * @throws BizException 业务异常
     */
    TreeDto sign(CommercialUserReq req) throws BizException;

    /**
     * 种果实
     *
     * @param plantReq    用户参数、位置信息
     * @return 用户信息、土地信息、种子仓库、签到信息
     * @throws BizException 业务异常
     */
    TreeDto plant(PlantReq plantReq) throws BizException;

    /**
     * 收果实
     *
     * @param req  用户参数、种子编号
     * @return 用户信息，奖励信息
     * @throws BizException 业务异常
     */
    TreeDto pick(PickReq req) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param missionReq   用户参数、任务编号
     * @return 用户信息，奖励信息
     * @throws BizException 业务异常
     */
    TreeDto finishMission(FinishMissionReq missionReq) throws BizException;

    /**
     * 种一棵树
     *
     * @param req 用户参数
     * @return 用户信息
     * @throws BizException 业务异常
     */
    TreeDto plantTree(PlantTreeReq req) throws BizException;

    /**
     * 果树图鉴
     * @param req 用户参数
     * @return 果树图鉴
     * @throws BizException 业务异常
     */
    TreeAlbumDetailDto getTreeAlbumDetail(CommercialUserReq req) throws BizException;

    /**
     * 用户互动游戏
     * @param req 用户请求参数
     * @return 奖励类型
     * @throws BizException 业务异常
     */
    TreeRewardDto userInteractiveReward(CommercialUserReq req) throws BizException;

    /**
     * 修改黄金采摘期的时间
     */
    Boolean updateGoldPick(ResetForTestReq req) throws BizException;

    /**
     * 换天
     * @param req 换天用户数据
     * @return 是否成功
     * @throws BizException 业务异常
     */
    Boolean resetForTest(ResetForTestReq req) throws BizException;
}
