package cn.com.duiba.tuia.commercial.center.api.remoteservice.synthesis;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.ActivityRequestDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.SynthesisDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynBuyReqDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynBuyRespDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynCompoundReqDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynCompoundRespDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynRecycleReqDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynRecycleRespDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.req.SynReportReqDTO;

/**
 * @author lijicong
 * @since 2020-05-29
 */
@AdvancedFeignClient
public interface RemoteSynthesisService {

    SynthesisDTO initialize(ActivityRequestDTO activityRequest) throws BizException;

    Boolean updateGuideStep(ActivityRequestDTO activityRequest) throws BizException;

    SynBuyRespDTO buy(ActivityRequestDTO activityRequest, SynBuyReqDTO synBuyReq) throws BizException;

    SynCompoundRespDTO compound(ActivityRequestDTO activityRequest, SynCompoundReqDTO synCompoundReq) throws BizException;

    SynRecycleRespDTO recycle(ActivityRequestDTO activityRequest, SynRecycleReqDTO synRecycleReq) throws BizException;

    SynthesisDTO report(ActivityRequestDTO activityRequest, SynReportReqDTO synReportReq) throws BizException;

}
