package cn.com.duiba.tuia.commercial.center.api.remoteservice.synthesis;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.ActivityRequestDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.synthesis.SynUserFoodGroupDTO;

import java.util.List;

/**
 * 合成游戏-成就/美食图鉴
 * @author lijicong
 * @since 2020-05-29
 */
@AdvancedFeignClient
public interface RemoteSynthesisAchievementService {

    /**
     * 获取用户图鉴组
     * @param activityRequest
     * @return
     * @throws BizException
     */
    List<SynUserFoodGroupDTO> listUserFoodGroup(ActivityRequestDTO activityRequest) throws BizException;

    /**
     * 领取图鉴组奖励
     * @param activityRequest
     * @param foodGroupSn
     * @return
     * @throws BizException
     */
    boolean receiveFoodGroupPrize(ActivityRequestDTO activityRequest, Long foodGroupSn) throws BizException;

}
