package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author lijicong
 * @since 2020-06-05
 */
@Getter
@Setter
public class SynUserFoodDTO extends SynFoodDTO {

    @ApiModelProperty(value = "美食图鉴组ids")
    private List<Long> foodGroupIds;

    @ApiModelProperty(value = "美食组序号")
    private List<Long> foodGroupSns;

    @ApiModelProperty(value = "美食图鉴ids")
    private List<Long> foodIds;

    @ApiModelProperty(value = "美食图鉴序号")
    private List<Long> foodSns;

    @ApiModelProperty(value = "美食图鉴集合")
    private List<SynUserFoodItemDTO> foods;

    @ApiModelProperty(value = "宠物图鉴集合")
    private List<SynUserPetItemDTO> pets;

    @ApiModelProperty(value = "是否领取奖励")
    private Boolean hasPrize;

    @ApiModelProperty(value = "动效状态 0:未播放 1:已播放")
    private Integer status;

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SynUserFoodItemDTO implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "序号")
        private Long sn;

        @ApiModelProperty(value = "动效状态 0:未播放 1:已播放")
        private Integer status;

    }

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SynUserPetItemDTO implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "等级")
        private Integer grade;

        @ApiModelProperty(value = "动效状态 0:未播放 1:已播放")
        private Integer status;
    }

    public void addUserFood(Long foodId, Long foodSn) {
        getFoodIds().add(foodId);
        getFoods().add(new SynUserFoodItemDTO(foodSn, 0));
    }

    public void addUserFoodGroup(Long foodGroupId, Long foodGroupSn) {
        getFoodGroupIds().add(foodGroupId);
        getFoodGroupSns().add(foodGroupSn);
    }

    public void addUserPet(Integer gradle) {
        getPets().add(new SynUserPetItemDTO(gradle, 0));
    }

    public Integer findUserFoodItemStatus(Long foodSn) {
        if (foodSn == null || CollectionUtils.isEmpty(getFoodSns())) {
            return 0;
        }
        SynUserFoodItemDTO synUserFoodItemDTO = getFoods().stream().filter(item -> foodSn.equals(item.getSn())).findAny().orElse(null);
        if (synUserFoodItemDTO == null) {
            return 0;
        }
        return synUserFoodItemDTO.getStatus();
    }

    public static SynUserFoodDTO build() {
        SynUserFoodDTO userFoodDTO = new SynUserFoodDTO();
        userFoodDTO.setFoodGroupIds(new ArrayList<>());
        userFoodDTO.setFoodGroupSns(new ArrayList<>());
        userFoodDTO.setFoodIds(new ArrayList<>());
        userFoodDTO.setFoods(new ArrayList<>());
        userFoodDTO.setPets(new ArrayList<>());
        return userFoodDTO;
    }

}
