package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * @author lijicong
 * @since 2020-06-01
 */
@Setter
@Getter
public class SynConfigGiftDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "媒体ID")
    private Long appId;

    @ApiModelProperty(value = "新手礼包配置JSON")
    private NewGiftsConfigDTO newGiftsConfig;

    @ApiModelProperty(value = "三日礼包配置JSON")
    private ThirdGiftsConfigDTO thirdGiftsConfig;

    @ApiModelProperty(value = "翻倍配置JSON")
    private DoubleConfigDTO doubleConfig;

    @Setter
    @Getter
    public static class NewGiftsConfigDTO implements Serializable {
        private static final long serialVersionUID = 1L;
        @ApiModelProperty(value = "新手奖励现金金额")
        private Integer cashAmount;
    }

    @Setter
    @Getter
    public static class ThirdGiftsConfigDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        private Integer day1Amount;

        private Integer day2Amount;

        private Integer day3Amount;
    }

    @Setter
    @Getter
    public static class DoubleConfigDTO implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "现金翻倍次数")
        private Integer cashLimit;

        @ApiModelProperty(value = "离线收益翻倍次数")
        private Integer offlineRevenueLimit;

    }
}
