package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 用户个人合成结果的奖励配置
 * Created by zxw on 2020-06-04.
 */

@Data
public class SynUserGiftConfigDTO implements Serializable {

    @ApiModelProperty(value = "礼物配置")
    private Config gift;

    @ApiModelProperty(value = "票卷配置")
    private Config ticket;

    @ApiModelProperty(value = "礼包出票卷配置")
    private Config giftTicket;

    @ApiModelProperty(value = "礼包出现金配置（这个只有区间存这，别的不存）")
    private Config giftCash;

    @ApiModelProperty(value = "当前合成次数")
    private Long curComposeTimes;

    @ApiModelProperty(value = "当前收到礼包的次数")
    private Long curReceiveGift;


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public class Config implements Serializable {

        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "是否启用")
        private Boolean enable;

        @ApiModelProperty(value = "当前获取次数")
        private Integer current;

        @ApiModelProperty(value = "第N次操作触发")
        private Integer next;

        @ApiModelProperty(value = "最大获取次数")
        private Integer maxNum;

        @ApiModelProperty(value = "最初需要的操作次数")
        private List<Integer> initList;

        @ApiModelProperty(value = "下限")
        private Integer lower;

        @ApiModelProperty(value = "上限")
        private Integer upper;

        /**
         * 是否还有余量
         *
         * @return
         */
        public Boolean enough() {
            return this.current < this.maxNum;
        }

        /**
         * 返回下次的N值
         *
         * @return
         */
        public Integer calculate() {
            this.next = this.next == null ? 0 : this.next;
            if (CollectionUtils.isEmpty(this.getInitList())
                    || this.getInitList().size() < this.current) {
                return this.next + RandomUtils.nextInt(this.lower, this.upper + 1);
            }
            return this.getInitList().get(this.current - 1);
        }

    }


}
