package cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * FarmSaveUserRewardReq
 *
 * @author huangruodan
 * @date 2019-11-27
 */

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FarmSaveUserRewardReq implements Serializable {

    private static final long serialVersionUID = 5980983139671142807L;

    private Long id;
    /**
     * 修改金币数
     */
    private Long updateCash;

    /**
     * 修改的待领取金币数
     */
    private Long updateClearedCash;


    /**
     * 用户userId
     */
    private Long bizUserId;

    /**
     * 收益类型  1-设施  2 种子 3 灌溉 4、离线收益 5、任务
     */
    private Integer businessType;

    private Integer subType;

    /**
     * 修改的红包数量
     */
    private Integer updateRedPacketNum;

    /**
     * 修改的待领取红包数量
     */
    private Integer updateClearedRedPacketNum;


    /**
     * 上次领取时间
     */
    private Date lastGetTime;

    /**
     * 上次统计时间
     */
    private Date lastCountTime;

    /**
     * 开始统计时间
     */
    private Date thisStartCountTime;

    /**
     * 该周期结束时间
     */
    private Date periodFinishTime;

    /**
     * 红包明细id列表
     */
    private String redPacketInfoIds;


}
