package cn.com.duiba.tuia.ecb.center.api.dto.cpd;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
 * 应用试玩列表dto
 * @author lichao 2019/4/4
 */
@ApiModel("app列表对象")
public class CPDListDetailDto implements Serializable {


    @ApiModelProperty("应用id，第三方的广告id")
    private String id;

    @ApiModelProperty("当前的任务状态 -1不可用 0初始化 1已下载过 2可领取 3已试玩不可领取")
    private int missionStatus;

    @ApiModelProperty("应用来源,")
    private Integer appSource;

    @ApiModelProperty("应用名称")
    private String appName;

    @ApiModelProperty("应用描述")
    private String appDesc;

    @ApiModelProperty("应用图标")
    private String appLogo;

    @ApiModelProperty("下载地址")
    private String appUrl;

    @ApiModelProperty("包名")
    private String appPackage;

    @ApiModelProperty("应用大小")
    private String appSize;

    @ApiModelProperty("状态文案")
    private String buttonText;

    @ApiModelProperty("标签")
    private CpdTagDto cpdTag;

    //奖励提示:需要时使用
    @ApiModelProperty("")
    private String rewardTips;

    @ApiModelProperty("app最短体验时长 单位秒")
    private Integer rewardExpTime;

    @ApiModelProperty("今天的奖励")
    private Integer reward;

    @ApiModelProperty("奖励分布,备用,当业务需要时使用([10,20,30])")
    private String rewardSet;

    @ApiModelProperty("下载完成的时间")
    private Date gmtCreate;

    @ApiModelProperty("第一次领取时间")
    private Date firstAcceptTime;

    @ApiModelProperty("扩展字段")
    private String extInfo;

    private EmbedUrlDto embedUrls;

    private String orderId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getAppSource() {
        return appSource;
    }

    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppDesc() {
        return appDesc;
    }

    public void setAppDesc(String appDesc) {
        this.appDesc = appDesc;
    }

    public String getAppLogo() {
        return appLogo;
    }

    public void setAppLogo(String appLogo) {
        this.appLogo = appLogo;
    }

    public String getAppUrl() {
        return appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppSize() {
        return appSize;
    }

    public void setAppSize(String appSize) {
        this.appSize = appSize;
    }

    public String getRewardTips() {
        return rewardTips;
    }

    public void setRewardTips(String rewardTips) {
        this.rewardTips = rewardTips;
    }

    public Integer getRewardExpTime() {
        return rewardExpTime;
    }

    public void setRewardExpTime(Integer rewardExpTime) {
        this.rewardExpTime = rewardExpTime;
    }

    public Integer getReward() {
        return reward;
    }

    public void setReward(Integer reward) {
        this.reward = reward;
    }

    public String getRewardSet() {
        return rewardSet;
    }

    public void setRewardSet(String rewardSet) {
        this.rewardSet = rewardSet;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }



    public int getMissionStatus() {
        return missionStatus;
    }

    public void setMissionStatus(int missionStatus) {
        this.missionStatus = missionStatus;
    }

    public EmbedUrlDto getEmbedUrls() {
        return embedUrls;
    }

    public void setEmbedUrls(EmbedUrlDto embedUrls) {
        this.embedUrls = embedUrls;
    }

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public CpdTagDto getCpdTag() {
        return cpdTag;
    }

    public void setCpdTag(CpdTagDto cpdTag) {
        this.cpdTag = cpdTag;
    }

    public Date getFirstAcceptTime() {
        return firstAcceptTime;
    }

    public void setFirstAcceptTime(Date firstAcceptTime) {
        this.firstAcceptTime = firstAcceptTime;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
}
