package cn.com.duiba.tuia.ecb.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * Created by xuefeng on 2019/4/8.
 */
public enum ChangeExpenseCode implements ChangeTradeCode {
    /**
     * 提现
     */
    WITHDRAW(1, "提现"),

    ;


    private Integer code;
    private String  desc;
    private static final Map<Integer, ChangeExpenseCode> CACHE = Maps.uniqueIndex(Arrays.asList(ChangeExpenseCode.values()),
            ChangeExpenseCode::getCode);

    ChangeExpenseCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    public static ChangeExpenseCode get(Integer code) {
        return CACHE.get(code);
    }
}
