package cn.com.duiba.tuia.ecb.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * Created by xuefeng on 2019/4/8.
 */
public enum ChangeIncomeCode implements ChangeTradeCode {

    /**
     * 签到奖励
     */
    SIGN_IN(1, "签到奖励"),

    /**
     * 试玩奖励
     */
    TRY_PLAY_REWARD(2, "试玩奖励"),

    /** 活跃任务的奖励 */
    TRY_ACTIVITY_REWARD(3, "试玩奖励"),

    WITHDRAW_TURN_DOWN(4, "提现退还"),

    MONEY_TREE_COIN(5, "摇钱树奖励"),

    /** 幂动奖励 **/
    TRY_MIDONG_REWARD(6, "试玩奖励"),
    ;


    private Integer code;

    private String desc;

    private static final Map<Integer, ChangeIncomeCode> CACHE = Maps.uniqueIndex(Arrays.asList(ChangeIncomeCode.values()),
            ChangeIncomeCode::getCode);

    ChangeIncomeCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static ChangeIncomeCode get(Integer code) {
        return CACHE.get(code);
    }
}
