package cn.com.duiba.tuia.ecb.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.api.req.WithdrawApplyReq;

import java.util.List;

/**
 * Created by xuefeng on 2019/7/10.
 */
@AdvancedFeignClient
public interface RemoteVideoWithDrawService {

    /**
     * 提现申请
     * @param withdrawApplyReq
     * @return
     */
    Long apply(WithdrawApplyReq withdrawApplyReq);

    /**
     * 根据用户id&account统计数据
     * @return
     */
    Integer countByUserId(Long userId, String account);

    /**
     * 根据流水ids审批
     * @param serialNumbers
     * @return
     */
    Boolean batchPass(List<Long> serialNumbers) throws BizException;
}
